/*
 * Copyright (C) 2022 Open Source Robotics Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include <gz/common/Util.hh>
#include <ignition/common/config.hh>

#define IGN_HOMEDIR GZ_HOMEDIR

#define IGN_NANO_TO_SEC GZ_NANO_TO_SEC
#define IGN_SEC_TO_NANO GZ_SEC_TO_NANO
#define IGN_MS_TO_NANO GZ_MS_TO_NANO
#define IGN_US_TO_NANO GZ_US_TO_NANO
#define IGN_SPEED_OF_LIGHT GZ_SPEED_OF_LIGHT

#define IGN_SLEEP_S(_s) GZ_SLEEP_S(_s)
#define IGN_SLEEP_US(_us) GZ_SLEEP_US(_us)
#define IGN_SLEEP_MS(_ms) GZ_SLEEP_MS(_ms)
#define IGN_SLEEP_NS(_ns) GZ_SLEEP_NS(_ns)

#define IGN_SYSTEM_TIME() GZ_SYSTEM_TIME()
#define IGN_SYSTEM_TIME_S() GZ_SYSTEM_TIME_S()
#define IGN_SYSTEM_TIME_US() GZ_SYSTEM_TIME_US()
#define IGN_SYSTEM_TIME_MS() GZ_SYSTEM_TIME_MS()
#define IGN_SYSTEM_TIME_NS() GZ_SYSTEM_TIME_NS()

#define IGN_ASSERT(_expr, _msg) GZ_ASSERT(_expr, _msg)
