/*
 * Copyright (C) 2021 Open Source Robotics Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/
//! [complete]
#include <iostream>
#include <gz/math/Rand.hh>

// You can plot the data generated by this program by following these
// steps.
//
// 1. Run this program and save the output to a file:
//     ./rand_example normal > normal.data
//     ./rand_example uniform > uniform.data
//
// 2. Use gnuplot to create a plot:
//     gnuplot -c rand_view_normal.gp > normal.jpg
//     gnuplot -c rand_view_uniform.gp > uniform.jpg
int main(int argc, char **argv)
{
  if (argc < 2)
  {
    std::cout << "./rand_example [normal, uniform]" << '\n';
    return -1;
  }
  for (int i = 0; i < 100000; ++i)
  {
    double value = 0.0;
    if (std::string(argv[1]) == "normal")
    {
      value = gz::math::Rand::DblNormal(0, 100);
    }
    else if (std::string(argv[1]) == "uniform")
    {
      value = gz::math::Rand::DblUniform(0, 1000);
    }
    else
    {
      std::cout << "./rand_example [normal, uniform]" << '\n';
      return -1;
    }

    std::cout << value << std::endl;
  }

  return 0;
}
//! [complete]
